limX = 200;
deltaX = 0.0025;
x = -limX:deltaX:limX;
xConv = [-2*limX:deltaX:2*limX];

sig1 = 1.15;
y1 = lognpdf(x, 0, sig1);

mu1b = 0.5;
sig1b = 0.3;
y1b = lognpdf(x, mu1b, sig1b);

mu2 = 0.5;
sig2 = 0.3;
y2 = lognpdf(x, mu2, sig2);

sig2b = 1.4;
y2b = lognpdf(x, 0, sig2b);

iy1b = y1b(end:-1:1);
yy1 = conv(y1, iy1b) * deltaX;
iy2b = y2b(end:-1:1);
yy2 = conv(y2, iy2b) * deltaX;

[meanConv1, medConv1, meanIdx1, medIdx1] = DensityToMeanMedian(xConv, yy1);
[meanConv2, medConv2, meanIdx2, medIdx2] = DensityToMeanMedian(xConv, yy2);

prX1LeqX2 = ProbabilityX1LeqX2(deltaX, yy1, yy2);
fprintf("Pr(value 2 > value 1) = %f\n\n", prX1LeqX2)

figure
hold on
    plot(xConv, yy1, 'Color', 'red');
    plot(xConv, yy2, 'LineStyle', '--', 'Color', 'blue');
    
    plot([meanConv1 meanConv1], [0, yy1(meanIdx1)], 'Color', 'red', 'LineWidth', 2)
    plot([medConv1 medConv1], [0, yy1(medIdx1)], 'Color', 'red')
    
    plot([meanConv2 meanConv2], [0, yy2(meanIdx2)], 'Color', 'blue',  'LineStyle', ':', 'LineWidth', 2)
    plot([medConv2 medConv2], [0, yy2(medIdx2)], 'Color', 'blue', 'LineStyle', '--')
    
    xlim([-5 5])
    xlabel('estimated value')
    ylabel('density')
    legend('value 1', 'value 2')
hold off
